/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.OnBlockSmeltCheck;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.UntouchingEnchantment;

public class SmelterEnchantment
extends CustomEnchantment {
    public SmelterEnchantment() {
        this.rarity(Enchantment.Rarity.UNCOMMON).category(EnchantmentCategory.DIGGER).slots(EquipmentSlots.MAINHAND).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof UntouchingEnchantment) && super.m_5975_(enchantment);
    }

    @AutoInstance
    public static class Handler {
        final Supplier<SmelterEnchantment> enchantment = Registries.SMELTER;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("Smelter").comment("Destroyed blocks are automatically smelted.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnBlockSmeltCheck.listen((Consumer)OnBlockSmeltCheck.ENABLE_SMELT).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.player)).insertTo(group);
        }
    }
}

